﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using MicroRWD.Common;
using MicroRWD.QT;

namespace MicroRWD.UI.QT
{
    public partial class CardPanel : UserControl
    {
        #region Constructor

        public CardPanel()
        {
            InitializeComponent();
        }
        
        #endregion


        #region Public Methods

        public void MyStatusChangedEventHandler(object sender, StatusUpdateEventArgs args)
        {
            // Update view(s)
            UpdatePortStateLabel(Program.Controller.Reader.PortState);
        }

        public void SetVisible(bool _visible)
        {
            Visible = _visible;
        }

        #endregion


        #region Private Methods

        private void UpdatePortStateLabel(PortState _state)
        {
            switch (_state)
            {
                case PortState.Closed:
                    this.UIThread(() => this.portStateLabel.Text = "COM PORT NOT OPEN");
                    break;

                case PortState.Open:
                    this.UIThread(() => this.portStateLabel.Text = "NOT CONNECTED");
                    break;

                case PortState.Connected:
                    this.UIThread(() => this.portStateLabel.Text = "CONNECTED");
                    break;
            }
        }

        #endregion


        #region Event Handling

        // Handler for exit button click
        private void exitButton_Click(object sender, EventArgs e)
        {
            // Terminate all event loops and return control to Program.cs
            Application.Exit();
        }

        // Handler for Hitag1 button click
        private void hitag1Button_Click(object sender, EventArgs e)
        {
            // Program reader
            if (Program.Controller.Reader.SetMode(Mode.HITAG1_S))
            {
                // Select view
                Program.Controller.SelectDataViewPanel(Mode.HITAG1_S);
            }
        }

        // Handler for Hitag2 button click
        private void hitag2Button_Click(object sender, EventArgs e)
        {
            // Program reader
            if (Program.Controller.Reader.SetMode(Mode.HITAG2))
            {
                // Select view
                Program.Controller.SelectDataViewPanel(Mode.HITAG2);
            }
        }

        // Handler for EM400X button click
        private void em4102Button_Click(object sender, EventArgs e)
        {
            // Program reader
            if (Program.Controller.Reader.SetMode(Mode.EM400X))
            {
                // Select view
                Program.Controller.SelectDataViewPanel(Mode.EM400X);
            }
        }

        // Handler for MC200 button click
        private void mcrf200Button_Click(object sender, EventArgs e)
        {
            // Program reader
            if (Program.Controller.Reader.SetMode(Mode.MC200))
            {
                // Select view
                Program.Controller.SelectDataViewPanel(Mode.MC200);
            }
        }

        private void CardPanel_Load(object sender, EventArgs e)
        {
            // Register for status update events unless in design mode
            if (!DesignMode && (Program.Controller != null))
            {
                Program.Controller.Reader.StatusUpdateEvent += MyStatusChangedEventHandler;
            }
        }

        #endregion

    }
}
